<div class="page-wrapper">
    <!-- BEGIN PAGE HEADER -->
    <div class="page-header d-print-none" aria-label="Page header">
        <div class="container-xl">
            <div class="row g-2 align-items-center">
                <div class="col">
                    <h2 class="page-title">Sales Report</h2>
                </div>
                <div class="col-auto ms-auto d-print-none">
                    <div class="d-flex">
                        <ol class="breadcrumb breadcrumb-arrows" aria-label="breadcrumbs">
                            <li class="breadcrumb-item">
                                <a href="<?= base_url('seller/home') ?>">Home</a>
                            </li>
                               <li class="breadcrumb-item active" aria-current="page">
                                <a href="#"> Report</a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page">
                                <a href="#">Sales Report</a>
                            </li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- END PAGE HEADER -->

    <div class="page-body">
        <div class="container-xl">
            <div class="col-12">
                <div class="card">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h3 class="card-title"> <i class="ti ti-chart-bar"></i>Sales Reports</h3>
                            <h3 class="font-weight-bold text-primary">
                                <i class="ti ti-coins mr-2"></i> Total Order Value:
                                <span id="total-order-sum" class="text-dark"><?= isset($currency) ? $currency : '$' ?>
                                </span>
                            </h3>
                        </div>
                        <div class="card-body">
                            <div class="gaps-1-5x">
                                <div class="row d-flex align-items-end flex-wrap">

                                    <!-- Date Filter -->
                                    <div class="form-group col-12 col-md-3 mb-3">
                                        <label for="datepicker" class="form-label">Date and Time Range:</label>
                                        <div class="input-icon">
                                            <input type="text" id="datepicker" class="form-control" value=""
                                                autocomplete="off" />
                                            <input type="hidden" id="start_date" class="form-control float-right">
                                            <input type="hidden" id="end_date" class="form-control float-right">
                                            <span class="input-icon-addon">
                                                <i class="ti ti-clock"></i>
                                            </span>
                                        </div>
                                    </div>

                                    <!-- Payment Method Filter -->
                                    <div class="form-group col-12 col-md-3 mb-3">
                                        <label for="payment_method_filter" class="form-label">Payment Method</label>
                                        <select id="payment_method_filter" class="form-control">
                                            <option value="">All</option>
                                            <?php
                                            $this->db->select('payment_method, COUNT(*) as usage_count')
                                                ->from('orders')
                                                ->where('payment_method IS NOT NULL')
                                                ->where('payment_method !=', '')
                                                ->group_by('payment_method')
                                                ->order_by('usage_count', 'DESC');

                                            $payment_methods = $this->db->get()->result_array();

                                            foreach ($payment_methods as $method) {
                                                $value = $method['payment_method'];
                                                $label = ucfirst(str_replace('_', ' ', $value));
                                                echo '<option value="' . htmlspecialchars($value) . '">' . htmlspecialchars($label) . '</option>';
                                            }
                                            ?>
                                        </select>
                                    </div>

                                    <!-- Order Status Filter -->
                                    <div class="form-group col-12 col-md-3 mb-3">
                                        <label for="order_status_filter" class="form-label">Order Status</label>
                                        <select id="order_status_filter" class="form-control">
                                            <option value="">All</option>
                                            <?php
                                            $preferred_order = [
                                                'awaiting' => 'Awaiting',
                                                'received' => 'Received',
                                                'processed' => 'Processed',
                                                'shipped' => 'Shipped',
                                                'delivered' => 'Delivered',
                                                'cancelled' => 'Cancelled',
                                                'returned' => 'Returned',
                                                'return_request_pending' => 'Return Request Pending',
                                                'return_request_approved' => 'Return Request Approved',
                                                'return_request_decline' => 'Return Request Declined'
                                            ];

                                            $this->db->select('active_status')
                                                ->from('order_items')
                                                ->distinct();

                                            $db_statuses = $this->db->get()->result_array();
                                            $db_status_values = array_column($db_statuses, 'active_status');

                                            foreach ($preferred_order as $value => $label) {
                                                if (in_array($value, $db_status_values)) {
                                                    echo '<option value="' . htmlspecialchars($value) . '">' . htmlspecialchars($label) . '</option>';
                                                }
                                            }

                                            $other_statuses = array_diff($db_status_values, array_keys($preferred_order));
                                            sort($other_statuses);

                                            foreach ($other_statuses as $status_value) {
                                                $status_label = ucfirst(str_replace('_', ' ', $status_value));
                                                echo '<option value="' . htmlspecialchars($status_value) . '">' . htmlspecialchars($status_label) . '</option>';
                                            }
                                            ?>
                                        </select>
                                    </div>

                                    <!-- Filter and Clear Buttons -->
                                    <div class="form-group col-12 col-md-3 d-flex justify-content-end gap-2 mb-3">
                                        <button type="button" class="btn btn-primary"
                                            onclick="status_date_wise_search()">
                                            <i class="ti ti-search"></i> Filter
                                        </button>
                                        <button type="button" class="btn btn-outline-secondary" onclick="resetfilters()"
                                            aria-label="Clear Filters">
                                            <i class="ti ti-refresh"></i> Reset
                                        </button>
                                    </div>

                                </div>
                            </div>

                            <!-- Sales Report Table -->
                            <table id="sales-report-table" class="table table-striped" data-toggle="table"
                                data-url="<?= base_url('seller/Sales_report/get_seller_sales_report_list') ?>"
                                data-detail-view="true" data-detail-formatter="salesReport" data-auto-refresh="true"
                                data-side-pagination="server" data-pagination="true"
                                data-page-list="[5, 10, 25, 50, 100, 200, All]" data-search="true"
                                data-trim-on-search="false" data-show-columns="true" data-show-columns-search="true"
                                data-show-refresh="true" data-mobile-responsive="true" data-sort-name="id"
                                data-sort-order="DESC" data-toolbar="" data-show-export="true"
                                data-maintain-selected="true" data-query-params="sales_report_query_params"
                                data-export-types='["txt","excel"]'>
                                <thead>
                                    <tr>
                                        <th data-field="id" data-sortable="true"><?= labels('id', 'Item ID') ?></th>
                                        <th data-field="product_name" data-sortable="true">
                                            <?= labels('product_name', 'Product Name') ?>
                                        </th>
                                        <th data-field="final_total" data-sortable="true">
                                            <?= labels('final_total', 'Final Total') ?>
                                        </th>
                                        <th data-field="payment_method" data-sortable="true">
                                            <?= labels('payment_method', 'Payment Method') ?>
                                        </th>
                                        <th data-field="date_added" data-sortable="true">
                                            <?= labels('date_added', 'Order Date') ?>
                                        </th>
                                        <th data-field="active_status" data-sortable="true">
                                            <?= labels('active_status', 'Order Status') ?>
                                        </th>
                                    </tr>
                                </thead>
                            </table>
                        </div>




                    </div>
                </div>
            </div>
        </div>
    </div>
</div>